package com.izenpe.zain.cliente.util;

import com.izenpe.zain.client.ZainConfig;

public class Propiedades {
	/**
	 * URL al punto de entrada a los servicios web de la plataforma
	 */
	public static final String ZAIN_ENDPOINT = "https://psf2.izenpe.com:8443/trustedx-gw/SoapGateway";
	
	/**
	 * Campo ASUNTO del certificado custodiado por la Plataforma para hacer
	 * firma en servidor
	 */
	public static final String ZAIN_SIGNER = "## NOMBRE DISTINTIVO DEL FIRMANTE##";
	
	/**
	 * Nombre distintivo del destinatario para el cifrado
	 */
	public static final String RECIPIENT_DN = "## NOMBRE DISTINTIVO DEL CERTIFICADO CON EL QUE SE VA A CIFRAR##";
	
	public static ZainConfig ZAIN_CONFIG;
	static {
		ZAIN_CONFIG = new ZainConfig();

		ZAIN_CONFIG.setAuthenticationPolicy("urn:izenpe:tws:policies:authentication:psf");

		ZAIN_CONFIG.setTruststoreActive(false);
		ZAIN_CONFIG.setTruststorePath("## PATH AL TRUSTSTORE##");
		ZAIN_CONFIG.setTruststorePassword("## PASSWORD DEL TRUSTSTORE##");

		ZAIN_CONFIG.setKeystoreActive(true);
		ZAIN_CONFIG.setKeystorePath("## PATH AL KEYSTORE DE AUTENTICACIN ##");
		ZAIN_CONFIG.setKeystorePassword("## PASSWORD DEL KEYSTORE DE AUTENTICACIN ##");
		ZAIN_CONFIG.setKeystoreType("PKCS12");

		ZAIN_CONFIG.setProxyActive(false);
		ZAIN_CONFIG.setProxyHost("");
		ZAIN_CONFIG.setProxyPort("");
		ZAIN_CONFIG.setProxyUsername("");
		ZAIN_CONFIG.setProxyPassword("");

		ZAIN_CONFIG.setTimeout(90000);


		ZAIN_CONFIG.setRequestLogActive(true);
		ZAIN_CONFIG.setRequestLogSavePath("./soap-messages/request/");
		ZAIN_CONFIG.setResponseLogActive(true);
		ZAIN_CONFIG.setResponseLogSavePath("./soap-messages/response/");
	}
}